/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.items;

import OreSpawn.entities.Squid;
import OreSpawn.items.ModelSquidZooka;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.TextureMapper;
import dangerzone.WorldRenderer;
import dangerzone.entities.Entity;
import dangerzone.gui.InventoryMenus;
import dangerzone.items.Item;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.opengl.Texture;

public class SquidZooka
extends Item {
    Texture texturebig = null;
    ModelSquidZooka ma = null;

    public SquidZooka(String n, String txt) {
        super(n, txt);
        this.maxstack = 1;
        this.maxuses = 500;
        this.attackstrength = 5;
        this.menu = InventoryMenus.HARDWARE;
        this.flipped = true;
    }

    public void renderMeHeld(WorldRenderer wr, Entity e, InventoryContainer ic, boolean isdisplay) {
        if (this.texturebig == null) {
            this.texturebig = TextureMapper.getTexture((String)"orespawnres/items/SquidZookatexture.png");
        }
        DangerZone.wr.loadtexture(this.texturebig);
        if (this.ma == null) {
            this.ma = new ModelSquidZooka();
        }
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)-2.0f, (float)-47.0f, (float)-4.0f);
        if (this.ma != null) {
            this.ma.render();
        }
    }

    public boolean onRightClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (clickedon != null) {
            return false;
        }
        if (holder == null) {
            return false;
        }
        if (holder.world.isServer) {
            Squid k = (Squid)holder.world.createEntityByName("OreSpawn:Squid", holder.dimension, holder.posx, holder.posy, holder.posz);
            if (k != null) {
                k.init();
                k.setWasShot();
                k.posx = holder.posx + (double)((float)Math.sin(Math.toRadians(holder.rotation_yaw_head - 20.0f)) * (holder.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head)));
                k.posy = holder.posy + (double)(holder.getHeight() * 9.0f / 10.0f) - (double)((float)Math.sin(Math.toRadians(holder.rotation_pitch_head)) * (holder.getWidth() + 2.0f));
                k.posz = holder.posz + (double)((float)Math.cos(Math.toRadians(holder.rotation_yaw_head - 20.0f)) * (holder.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head)));
                float x = (float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head));
                float y = -((float)Math.sin(Math.toRadians(holder.rotation_pitch_head)));
                float z = (float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head));
                float velocity = 6.0f;
                float variability = 0.2f;
                k.motionx = x * (velocity + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * variability * velocity);
                k.motiony = y * (velocity + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * variability * velocity);
                k.motionz = z * (velocity + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * variability * velocity);
                holder.world.spawnEntityInWorld((Entity)k);
            }
            holder.world.playSound("DangerZone:bow", holder.dimension, holder.posx, holder.posy + (double)holder.getHeight(), holder.posz, 0.5f, 1.0f + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * 0.3f);
            holder.world.playSound("DangerZone:little_splash", holder.dimension, holder.posx, holder.posy + (double)holder.getHeight(), holder.posz, 0.5f, 1.0f + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * 0.3f);
            holder.addKnockback((Entity)k, 1.0f, 0.15f);
            return true;
        }
        return false;
    }
}

